﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.IO;
using System.Diagnostics;
using Microsoft.Win32;
using System.Security.Principal;

namespace UE4Register
{
	class Program
	{
		static void Main(string[] args)
		{
			// elevate to admin if needed

			var identity = WindowsIdentity.GetCurrent();
			var principal = new WindowsPrincipal(identity);
			if (!principal.IsInRole(WindowsBuiltInRole.Administrator))
			{
				// Restart program and run as admin
				var exeName = System.Diagnostics.Process.GetCurrentProcess().MainModule.FileName;
				ProcessStartInfo startInfo = new ProcessStartInfo(exeName);
				startInfo.Verb = "runas";
				System.Diagnostics.Process.Start(startInfo);
				return;
			}

			string LocalDirectory = System.Environment.CurrentDirectory;
			//LocalDirectory = "D:/Dev/Main";
			string[] SubDirectories = Directory.GetDirectories(LocalDirectory);
			foreach (string SubDirectory in SubDirectories)
			{
				if (File.Exists(SubDirectory + "/Engine/Binaries/Win64/UE4Editor.exe")) 
				{
					// We have found a UE4 directory.  Check to see if it's in the registry.

					string FixedSubDirectory = SubDirectory.Replace("\\", "/");
					string BuildId = "";

					if (File.Exists(SubDirectory + "/UE4Register.key"))
					{
						BuildId = File.ReadAllText(FixedSubDirectory + "/UE4Register.key");
					}
					else
					{
						BuildId = Guid.NewGuid().ToString();
					}

					if (BuildId != "")
					{
						AdjustRegistryKey(BuildId, FixedSubDirectory);
					}
				}
			}
		}


		static void AdjustRegistryKey(string Key, string Directory)
		{
			// Look to see if this registry key exists in the registry...

			Console.WriteLine("Processing Engine Build [" + Key + "] at \"" + Directory + "\"... ");

			// Verify the keys...

			RegistryKey EpicGamesKey = null;
			RegistryKey EngineKey = null;
			RegistryKey BuildKey = null;

			EpicGamesKey = Registry.CurrentUser.OpenSubKey("Software\\Epic Games\\", true);
			if (EpicGamesKey == null)
			{
				RegistryKey SoftwareKey = Registry.CurrentUser.OpenSubKey("Software", true);
				EpicGamesKey = SoftwareKey.CreateSubKey("Epic Games Joe");
				
			}

			if (EpicGamesKey == null)
			{
				Console.WriteLine("Unable to create the required registry entry 'Software\\Epic Games'");
				return;
			}

			EngineKey = Registry.CurrentUser.OpenSubKey("Software\\Epic Games\\Unreal Engine", true);
			if (EngineKey == null)
			{
				EngineKey = EpicGamesKey.CreateSubKey("Unreal Engine");
			}

			if (EngineKey == null)
			{
				Console.WriteLine("Unable to create the required registry entry 'Software\\Epic Games\\Unreal Engine'");
				return;
			}

			BuildKey = Registry.CurrentUser.OpenSubKey("Software\\Epic Games\\Unreal Engine\\Builds", true);
			if (BuildKey == null)
			{
				BuildKey = EngineKey.CreateSubKey("Builds");
			}

			if (BuildKey == null)
			{
				Console.WriteLine("Unable to create the required registry entry 'Software\\Epic Games\\Unreal Engine\\Builds'");
				return;
			}

			RegistryKey RootKey = Registry.CurrentUser.OpenSubKey("Software\\Epic Games\\Unreal Engine\\Builds", true);
			if (RootKey != null)
			{
				foreach (string ValueName in RootKey.GetValueNames())
				{
					string UE4BuildId = ValueName;
					string UE4Path = (string)RootKey.GetValue(UE4BuildId);
					string FixedUE4Path = UE4Path.Replace("\\", "/");

					if (FixedUE4Path == Directory)
					{
						RootKey.DeleteValue(UE4BuildId);
					}
				}

				RootKey.SetValue(Key, Directory);
				RootKey.Close();
			}
		}

	}
}
